<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Admin\Website;
use App\Models\PremiumPackage;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PremiumPackageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $website = Website::latest()->first();
        $datas = PremiumPackage::orderBy('id', 'ASC')->get();

        return view('backend.pages.premium-package.index', compact('website', 'datas'));
    }
    
    public function get_premium_package_for_update(Request $request)
    {
        $data = PremiumPackage::find($request->id);

        return view('backend.pages.premium-package.update-form', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required',
        ]);

        $data = new PremiumPackage();
        $data->name = Str::ucfirst($request->input('name'));
        $data->duration = $request->input('duration');
        $data->cost = $request->input('cost');
        $data->features = implode("|",$request->features);
        $data->save();

        return redirect()->back()->with('message','Data added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name' => 'required',
        ]);

        $data = PremiumPackage::find($id);
        $data->name = Str::ucfirst($request->input('name'));
        $data->duration = $request->input('duration');
        $data->cost = $request->input('cost');
        $data->features = implode("|",$request->features);
        $data->save();

        return redirect()->back()->with('message','Data updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = PremiumPackage::find($id);
        $data->delete();

        return redirect()->back()->with('message','Data deleted Successfully');
    }
}
